void fit2_v0() {

  TVirtualFitter::SetDefaultFitter("Minuit");

  TGraphErrors* g = new TGraphErrors("pt_inv_cross_section_pp_200GeV.txt","%lg %lg %lg");
  g->Print();

  TCanvas* c1 =new TCanvas("c1");
  TH2F* frame = new TH2F("fr","frame",2,0.,15.,2,5e-9,1.);
  c1->SetLogy(1);
  frame->Draw();

  g->SetMarkerStyle(20);
  g->Draw("p");

  TF1 *f = new TF1("f","x*[0]/(1.+x/[1])^[2] ", 0.5, 14.);
  f->SetParameters(13.5214, 1.02383, 7.25756);

  TFitResultPtr r = g->Fit("f","F0qS","",0.,6.);
  r->Print("V");
  TMatrixDSym cov = r->GetCovarianceMatrix();
  cov.Print();

  f->Draw("same");
 
  TCanvas *c2 = new TCanvas("c2","contours",10,10,900,300);
  c2->cd();
  c2->Divide(3,1);

}
