void fit1_v0() {

  TVirtualFitter::SetDefaultFitter("Minuit");

  TGraphErrors* g = new TGraphErrors(5);
  g->SetPoint(0, 1, 1.7); g->SetPointError(0, 0, 0.5);
  g->SetPoint(1, 2, 2.3); g->SetPointError(1, 0, 0.3);
  g->SetPoint(2, 3, 3.5); g->SetPointError(2, 0, 0.4);
  g->SetPoint(3, 4, 3.3); g->SetPointError(3, 0, 0.4);
  g->SetPoint(4, 5, 4.3); g->SetPointError(4, 0, 0.6);

  TCanvas* c1 =new TCanvas("c1");
  TH2F* frame = new TH2F("fr","frame",2,0.,6.,2,0.,7.);
  frame->Draw();

  g->SetMarkerStyle(20);
  g->Draw("p");

  TF1* f = new TF1("f","pol1",0.,6.);
  TFitResultPtr r = g->Fit("f","F0qS","",0.,6.);
  r->Print("V");
  TMatrixDSym cov = r->GetCovarianceMatrix();
  cov.Print();

  f->Draw("same");
 
 TCanvas *c2 = new TCanvas("c2","contours");
  c2->cd();

  //Get contour for parameter 0 versus parameter 1  for ERRDEF=2 
  gMinuit->SetErrorDef(4); //note 4 and not 2!
  TGraph *gr2 = (TGraph*) gMinuit->Contour(80,0,1);
  gr2->SetFillColor(42);
  gr2->Draw("alf");

  //Get contour for parameter 0 versus parameter 2 for ERRDEF=1  
  gMinuit->SetErrorDef(1);
  TGraph *gr1 = (TGraph*) gMinuit->Contour(80,0,1);
  gr1->SetFillColor(38);
  gr1->Draw("lf");
 
}
