void error_prop_v0() {

  gStyle->SetOptStat(kFALSE);
  gStyle->SetOptTitle(0);

  TVirtualFitter::SetDefaultFitter("Minuit");

  TH1F* h = new TH1F("h","h",5, 0.5, 5.5);
  h->SetBinContent(1,1.7); h->SetBinError(1, 0.5);
  h->SetBinContent(2,2.3); h->SetBinError(2, 0.3);
  h->SetBinContent(3,3.5); h->SetBinError(3, 0.4);
  h->SetBinContent(4,3.3); h->SetBinError(4, 0.4);
  h->SetBinContent(5,4.3); h->SetBinError(5, 0.6);

  TCanvas* c1 =new TCanvas("c1","data+fit");
  h->SetMarkerStyle(20);
  h->Draw("pE1X0");

  TF1* f = new TF1("f","pol1",0.,6.);
  TFitResultPtr r = h->Fit("f","F0qS","",0.,6.);
  TMatrixDSym cov = r->GetCovarianceMatrix();
  cov.Print();

  f->Draw("same");

}
