void ana_v0() {

  // Analyse von pi0-Daten

  // buche Histogramm
  TH1F* hinv = new TH1F("hinv","invariante Masse",200,0.,1.);
  TH1F* hinvmix = new TH1F("hinvmix","invariante Masse (mixed events)",200,0.,1.);
  
  // read ntuple
  TFile* fdata = new TFile("pi0_vcal_data.root");

  const Int_t kMaxHit = 2000;
  Int_t nhit;
  
  Float_t pxdata[kMaxHit];
  Float_t pydata[kMaxHit];
  Float_t pzdata[kMaxHit];

  TTree* ntu = (TTree*) fdata->Get("ntu");
  ntu->SetBranchAddress("nhit", &nhit);
  ntu->SetBranchAddress("px", pxdata);
  ntu->SetBranchAddress("py", pydata);
  ntu->SetBranchAddress("pz", pzdata);

  const int iPufferMax = 2;
  Float_t px[iPufferMax][kMaxHit];
  Float_t py[iPufferMax][kMaxHit];
  Float_t pz[iPufferMax][kMaxHit];
  Float_t iTeilchen[iPufferMax];

  // Setze Anzahl der Teilchen in jedem Puffer auf null
  for (Int_t i = 0; i < iPufferMax; i++) {
    iTeilchen[i] = 0;
  }
  int iPufferAktuell = 0;

  for (Int_t iEvt=0; iEvt<ntu->GetEntries(); iEvt++) {

    ntu->GetEntry(iEvt);

    // fuelle Puffer
    for (int i=0; i<nhit; i++) {
      px[iPufferAktuell][i] = pxdata[i];
      py[iPufferAktuell][i] = pydata[i];
      pz[iPufferAktuell][i] = pzdata[i];

    }
    iTeilchen[iPufferAktuell] = nhit;

    // starte Analyse des letzten Events
    for (int i1 = 0; i1 < iTeilchen[iPufferAktuell]; i1++) {
           
      // --- Paare im selben Event
      // to be done ...
   

      //
      // --- Paare aus unterschiedlichen Events (Event Mixing)
      //
      // waehle alten Puffer
      int iPufferAlt;
	
      if (iPufferAktuell == 0) {
	iPufferAlt = 1;
      }
      else {
	iPufferAlt = 0;
      }

	
      for (int i2 = 0; i2 < iTeilchen[iPufferAlt]; i2++) {

	Float_t px1 = px[iPufferAktuell][i1];
	Float_t py1 = py[iPufferAktuell][i1];
	Float_t pz1 = pz[iPufferAktuell][i1];
	Float_t px2 = px[iPufferAlt][i2];
	Float_t py2 = py[iPufferAlt][i2];
	Float_t pz2 = pz[iPufferAlt][i2];

	Float_t pair_pt = sqrt(pow(px1+px2,2)+pow(py1+py2,2));

	if (pair_pt > 0) {
	  Float_t minv = calcinvm(px1,py1,pz1,px2,py2,pz2);
	  hinvmix->Fill(minv);
	}
	  
      }
	
    }

    // Bereite naechstes Event vor

    // Puffer umschalten
    iPufferAktuell++;
    if (iPufferAktuell == iPufferMax) {
      iPufferAktuell = 0;
    } 
      
  }
  
  // fitte und zeichne Histogramm mit invarianter Masse
  TH1F* hRatio = (TH1F*) hinv->Clone();    
  hRatio->Divide(hinvmix);
  hRatio->Draw();
   
  TF1* fc = new TF1("fc","pol0",0.,1.); 
  hRatio->Fit("fc","0q","",0.3,0.7);
  Float_t fitpar = fc->GetParameter(0);
  
  gStyle->SetCanvasColor(0);
  gStyle->SetPadColor(0);
  gStyle->SetCanvasBorderMode(0);
  gStyle->SetPadBorderMode(0); 
 
  gStyle->SetTitleXOffset(1.4); 
  gStyle->SetTitleYOffset(1.8); 
   
  gStyle->SetPadLeftMargin(0.17);
  gStyle->SetPadRightMargin(0.1);      // 0.1 = root default
  gStyle->SetPadTopMargin(0.1);
  gStyle->SetPadBottomMargin(0.14);

  hinv->SetXTitle("invariante Masse (GeV/c^{2})");
  hinv->SetYTitle("Haeufigkeit");
  hinv->Draw();
  hinvmix->Scale(fitpar);
  hinvmix->SetLineColor(kGreen);
  hinvmix->Draw("same");

  TH1F* hDiff = (TH1F*) hinv->Clone();
  hDiff->SetName("hDiff");
  hDiff->Add(hinvmix,-1);
  hDiff->Draw("same");

}


