void real_mix_fit_v0(){

  TCanvas *c1 = new TCanvas();
  gStyle->SetOptStat(0);
  gROOT->ForceStyle();

  TFile *f1 = new TFile("pi0_scan9_pid3_C9-17_bins64_rebin2_nSigEx3.0_W0_W1_W2_W3_E2_E3_date000000.root");

  // Get the real Events
  TH1F *hreal = (TH1F*)f1->Get("hRealSave26");
  TH1F *hmix = (TH1F*)f1->Get("hMixSave26");
  hmix->SetXTitle("m_{inv} (GeV/c^{2})");
  hmix->SetMarkerStyle(kFullCircle);
  hreal->SetXTitle("m_{inv} (GeV/c^{2})");
  hreal->SetMarkerStyle(kFullCircle);

  hreal->DrawCopy();
  c1->Update();
  c1->SaveAs("real.gif");
  if(getchar()=='q')return;

  TH1F* hratio = (TH1F*)hreal->Clone("hratio");
  hratio->Divide(hmix); 
  hratio->DrawCopy();

  // Reset peak areas...
  for(int ib = 1;ib<=hratio->GetNbinsX();ib++){
    Float_t x = hratio->GetBinCenter(ib);
    if(x < 0.130+3.*0.01){ // exclude pi0 (nominal mass 0.135!
      hratio->SetBinContent(ib,0);
      hratio->SetBinError(ib,0);
    }  
    if((x < 0.51+3.*0.03)&&(x > 0.548-3.*0.03)){ // exclude eta m = 0.548
      hratio->SetBinContent(ib,0);
      hratio->SetBinError(ib,0);
    }
    
  }
  hratio->SetMarkerColor(kBlue);
  hratio->DrawCopy("same");


  TF1 *poli1 = new TF1("poli1","pol1",0.1,0.9);
  hratio->Fit(poli1,"RQ0");
  poli1->SetRange(0,1.);

  c1->Update();
  c1->SaveAs("realovermix.gif");
  if(getchar()=='q')return;

  // scale mix....
  for(int ib = 1;ib<=hmix->GetNbinsX();ib++){
    Float_t x = hmix->GetBinCenter(ib);
    Float_t cont = hmix->GetBinContent(ib);
    Float_t err = hmix->GetBinError(ib);
    Float_t fScale = poli1->Eval(x);
    hmix->SetBinContent(ib,cont*fScale);
    hmix->SetBinError(ib,err*fScale);
  }

  hreal->DrawCopy();
  hmix->SetMarkerColor(kBlue);
  hmix->DrawCopy("same");
  c1->Update();
  c1->SaveAs("realscaledmix.gif");
  if(getchar()=='q')return;

  TH1F* hdiff = (TH1F*)hreal->Clone("hdiff");
  hdiff->Add(hmix,-1.);
  hdiff->DrawCopy();
  TF1 *myg1 = new TF1("myg","gaus",0.05,0.2);
  myg1->SetLineColor(kRed);
  hdiff->Fit(myg1,"R");
  TF1 *myg2 = new TF1("myg","gaus",0.4,0.6);
  myg2->SetLineColor(kYellow);
  hdiff->Fit(myg2,"R+");
  c1->Update();
  c1->SaveAs("realminusmix.gif");
  if(getchar()=='q')return;

  hdiff->SetTitle("");
  hdiff->DrawCopy("");
  TLegend *leg1 = new TLegend(0.3,0.5,0.8,0.7);
  leg1->SetFillColor(0);
  leg1->SetBorderSize(0);
  leg1->AddEntry(hdiff,"Background subtracted inv. mass","P");
  leg1->AddEntry(myg1,"Fit to #pi^{0} peak","L");
  leg1->AddEntry(myg2,"Fit to #eta peak","L");
  leg1->Draw("same");
  c1->Update();
  c1->SaveAs("realminusmix_nice.gif");

}
